<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once PAYMONEY_WOOCOMMERCE_ADDON_DIR . 'src/Common/Paymoney_WoocommercePaymentGateway.php';

class Paymoney_Payment extends Paymoney_WoocommercePaymentGateway
{    
    public function paymoney_set_payer( $paymoney_payer )
    {
        $this->paymoney_payer = $paymoney_payer;
        return $this;
    }

    public function paymoney_get_payer()
    {
        return $this->paymoney_payer;
    }

    public function paymoney_set_transaction( $paymoney_transaction )
    {
        $this->paymoney_transaction = $paymoney_transaction;
        return $this;
    }

    public function paymoney_get_transaction()
    {
        return $this->paymoney_transaction;
    }
    
    public function paymoney_set_redirect_urls( $paymoney_redirect_urls )
    {
        $this->paymoney_redirect_urls = $paymoney_redirect_urls;
        return $this;
    }

    public function paymoney_get_redirect_urls()
    {
        return $this->paymoney_redirect_urls;
    }

    public function paymoney_set_credentials( $paymoney_credentials )
    {
        $this->paymoney_credentials = $paymoney_credentials;
        return $this;
    }

    public function paymoney_get_credentials()
    {
        return $this->paymoney_credentials;
    }

    public function paymoney_set_approved_url( $paymoney_url )
    {
        $this->paymoney_approved_url = $paymoney_url;
        return $this;
    }

    public function paymoney_get_approved_url()
    {
        return $this->paymoney_approved_url;
    }

    public function paymoney_create()
    {
        $paymoney_access_token = $this->paymoney_get_access_token();

        $paymoney_approve_url  = $this->paymoney_send_transaction_info( $paymoney_access_token );

        if( $paymoney_approve_url->status == 'error' ) {
            return $paymoney_approve_url;
        }

        $this->paymoney_set_approved_url( $paymoney_approve_url );
    }

    private function paymoney_get_access_token()
    {
        $paymoney_array = $this->paymoney_get_credentials();

        if ( ! $paymoney_array['client_id'] || !$paymoney_array['client_secret'] ) {
            esc_html_e( 'Parameter array must contain client_id and client_secret.', 'paymoney-woocommerce-addon' ); exit;
        }

        $paymoney_client_id = $paymoney_array['client_id'];
        $paymoney_client_secret = $paymoney_array['client_secret'];
        $paymoney_payload['client_id'] = $paymoney_client_id;
        $paymoney_payload['client_secret'] = $paymoney_client_secret;
        $paymoney_res = $this->paymoney_execute( PAYMONEY_WOOCOMMERCE_BASE_URL .'merchant/api/verify','post' , $paymoney_payload );

        $paymoney_res = json_decode( $paymoney_res );
        if( ! $paymoney_res ) {
            esc_html_e( 'Something went wrong, please try again later.', 'paymoney-woocommerce-addon' ); exit;
        }
        if( $paymoney_res->status == 'error' ) {
            esc_html_e($paymoney_res->message); exit;
        }
        $response = $paymoney_res->data->access_token;
        return $response;
    }

    private function paymoney_send_transaction_info( $paymoney_token )
    {
        $paymoney_trans = $this->paymoney_get_transaction();
        $paymoney_payer = $this->paymoney_get_payer();
        $paymoney_redirect_urls = $this->paymoney_get_redirect_urls();
        $paymoney_amount = $paymoney_trans->paymoney_amount->paymoney_get_total();
        $paymoney_currency = $paymoney_trans->paymoney_amount->paymoney_get_currency();
        $paymoney_return_url = $paymoney_redirect_urls->paymoney_get_return_url();
        $paymoney_cancel_url = $paymoney_redirect_urls->paymoney_get_cancel_url();
        $paymoney_payment_method = $paymoney_payer->paymoney_get_payment_method();

        $paymoney_req['payer'] = $paymoney_payment_method;
        $paymoney_req['amount'] = $paymoney_amount;
        $paymoney_req['currency']  = $paymoney_currency;
        $paymoney_req['successUrl'] = $paymoney_return_url;
        $paymoney_req['cancelUrl'] = $paymoney_cancel_url;
        $paymoney_req['items'] = json_encode( $paymoney_trans->items );

        $paymoney_header = ['Authorization: Bearer ' . $paymoney_token];

        $paymoney_res = $this->paymoney_execute(PAYMONEY_WOOCOMMERCE_BASE_URL . 'merchant/api/transaction-info', 'POST', $paymoney_req, $paymoney_header);

        $paymoney_res = json_decode( $paymoney_res );

        if ( ! $paymoney_res ) {
            esc_html_e( 'Something went wrong, please try again later.', 'paymoney-woocommerce-addon' ); exit;
        }

        if ( $paymoney_res->status == 'error' ) {
            return $paymoney_res;
        }

        $paymoney_response = $paymoney_res->data->approvedUrl;
        return $paymoney_response;
    }
}