<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Paymoney_ProcessWoocommerceGateway extends WC_Payment_Gateway
{
    public function __construct()
    {
        $this->id = 'paymoney_woocommerce_addon_id';
        $this->method_title = PAYMONEY_WOOCOMMERCE_BRAND;
        /* translators: short description for payment gateway */
        $this->method_description = sprintf( esc_html__( 'WooCommerce Payment Gateway for %s', 'paymoney-woocommerce-addon' ), PAYMONEY_WOOCOMMERCE_BRAND );
        $this->title = PAYMONEY_WOOCOMMERCE_BRAND;
        $this->has_fields = false;
        $this->supports = array('products');

        // Load the settings
        $this->initFormFields();
        $this->init_settings();

        // Get option from admin settings
        $this->enabled = $this->get_option('enabled');
        $this->title = $this->get_option('title');
        $this->description = $this->get_option('description');
        $this->client_id = $this->get_option('client_id');
        $this->client_secret = $this->get_option('client_secret');

        add_action( 'paymoney_check_woocommerce_payment_gateway', array( $this, 'paymoney_check_response') );

        if ( is_admin() ) {
            add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
        }
    }

    public function initFormFields()
    {
        $this->form_fields = array(

            'enabled' => array(
                'title' => esc_html__( 'Enable', 'paymoney-woocommerce-addon' ),
                'type' => 'checkbox',
                /* translators: payment gateway enable/disable title */
                'label' => sprintf( esc_html__( 'Enable %s', 'paymoney-woocommerce-addon' ), PAYMONEY_WOOCOMMERCE_BRAND ),
                'default' => 'yes'
            ),
            'title' => array(
                'title' => esc_html__( 'Title', 'paymoney-woocommerce-addon' ),
                'type' => 'text',
                'description' => esc_html__( 'This controls the title which the user sees during checkout.','paymoney-woocommerce-addon' ),
                'default' => PAYMONEY_WOOCOMMERCE_BRAND
            ),
            'description' => array(
                'title' => esc_html__( 'Description', 'paymoney-woocommerce-addon' ),
                'type' => 'textarea',
                'description' => esc_html__( 'This controls the description which the user sees during checkout.', 'paymoney-woocommerce-addon' ),
                /* translators: description that is display during checkout */
                'default' => sprintf( esc_html__( 'Pay with %s', 'paymoney-woocommerce-addon' ), PAYMONEY_WOOCOMMERCE_BRAND ),
            ),
            'client_id' => array(
                'title' => esc_html__( 'Client ID', 'paymoney-woocommerce-addon' ),
                'type' => 'text',
                'default' => ''
            ),
            'client_secret' => array(
                'title' => esc_html__( 'Client Secret', 'paymoney-woocommerce-addon' ),
                'type' => 'password',
                'default' => ''
            ),
        );
    }

    public function process_payment( $order_id )
    {
        $paymoney_order = new WC_Order( $order_id );
        $paymoney_order_data  = $paymoney_order->get_data();

        // Get an instance of the WC_Order object
        $paymoney_order = wc_get_order($order_id);
        $paymoney_product = [];

        foreach ($paymoney_order->get_items() as $key => $paymoney_item) {
            $paymoney_product[] = [
                'id' => $paymoney_item->get_id(),
                'name' => $paymoney_item->get_name(),
                'quantity' => $paymoney_item->get_quantity(),
                'price' => $paymoney_item->get_subtotal(),
            ];
        }

        $paymoney_items = [
            'details' => $paymoney_product,
            'shipping_cost' => $paymoney_order_data['shipping_total'],
            'tax' => $paymoney_order_data['total_tax'],
            'discount' => $paymoney_order_data['discount_total'],
            'currency' => $paymoney_order_data['currency'],
        ];

        $paymoney_payer = new Paymoney_Payer();
        $paymoney_payer->paymoney_set_payment_method( PAYMONEY_WOOCOMMERCE_BRAND );

        $paymoney_amount = new Paymoney_Amount();
        $paymoney_amount->paymoney_set_total( $paymoney_order->get_total() )->paymoney_set_currency( get_woocommerce_currency() );

        $paymoney_transaction = new Paymoney_Transaction();
        $paymoney_transaction->paymoney_set_amount( $paymoney_amount );
        $paymoney_transaction->paymoney_set_items( $paymoney_items );

        $paymoney_base_url = $this->get_return_url( $paymoney_order );

        if ( strpos( $paymoney_base_url, '?') !== false ) {
            $paymoney_base_url .= '&';
        } else {
            $paymoney_base_url .= '?';
        }

        $paymoney_return_url = $paymoney_base_url . 'paymoney_woocommerce_payment_gateway=true&order_id=' . $order_id;

        $paymoney_redirect_urls = new Paymoney_RedirectUrls();
        $paymoney_redirect_urls->paymoney_set_return_url( $paymoney_return_url )->paymoney_set_cancel_url( $paymoney_order->get_cancel_endpoint() );

        $paymoney_payment = new Paymoney_Payment();
        $paymoney_payment->paymoney_set_credentials([
            'client_id' => $this->get_option('client_id'),
            'client_secret' => $this->get_option('client_secret')
        ])
        ->paymoney_set_redirect_urls($paymoney_redirect_urls)
        ->paymoney_set_payer($paymoney_payer)
        ->paymoney_set_transaction($paymoney_transaction);

        try {

            $paymoney_res = $paymoney_payment->paymoney_create();

            if ( $paymoney_res->status == 'error' ) {
                wc_add_notice(  $paymoney_res->message, 'error' );

                return array(
                    'result' => 'failure',
                    'redirect' => ''
                );
            }

            $paymoney_approval_url = $paymoney_payment->paymoney_get_approved_url();

            return array(
                'result' => 'success',
                'redirect' => $paymoney_approval_url
            );

        } catch (Exception $ex) {
            wc_add_notice( $ex->getMessage(), 'error' );
        }
        return array(
            'result' => 'failure',
            'redirect' => ''
        );
    }

    public function paymoney_check_response()
    {
        global $woocommerce;

        if (isset($_GET['paymoney_woocommerce_payment_gateway'])) {

            $paymoney_woocommerce_pg = $_GET['paymoney_woocommerce_payment_gateway'];
            $paymoney_order_id = explode('?', $_GET['order_id']);
            $paymoney_order_id = $paymoney_order_id[0];

            if ( $paymoney_order_id == 0 || $paymoney_order_id == '' ) {
                return;
            }

            $paymoney_order = new WC_Order( $paymoney_order_id );
            if ($paymoney_order->has_status('completed') || $paymoney_order->has_status('processing')) {
                return;
            }

            // Get Payment method id
            $paymoney_available_gateways = $woocommerce->payment_gateways->get_available_payment_gateways();
            $paymoney_current_gateway    = '';

            if ( !empty( $paymoney_available_gateways ) ) {
                if ( isset( $woocommerce->session->chosen_payment_method ) && isset( $paymoney_available_gateways[ $woocommerce->session->chosen_payment_method ] ) ) {
                    $paymoney_current_gateway = $paymoney_available_gateways[ $woocommerce->session->chosen_payment_method ];
                }
            }
            $paymoney_payment_id = $paymoney_current_gateway->id;

            if ($paymoney_woocommerce_pg == true) {
                $paymoney_order->update_status('completed');

                $paymoney_order->add_order_note( 
                /* translators: 1:payment method name 2:payment order id */
                sprintf( esc_html__( '%1$s payment approved, Transaction ID: %2$s.', 'paymoney-woocommerce-addon', 'paymoney-woocommerce-addon' ), $this->title, $paymoney_order_id ) );
                $woocommerce->cart->empty_cart();
            }

            if ($paymoney_woocommerce_pg == 'cancel') {
                $paymoney_order = new WC_Order( $paymoney_order_id );

                $paymoney_order->update_status('cancelled', 
                /* translators: 1:payment method name 2:payment id */
                sprintf( esc_html__( '%1$s payment cancelled, Transaction ID: %2$d.', 'paymoney-woocommerce-addon', 'paymoney-woocommerce-addon' ), $this->title, $paymoney_payment_id ) );
            }
        }
        return;
    }
}